# 開発環境構築手順書 (Windows/XAMPP)

この手順書では、**未経験エンジニア**の方を対象に、勤怠管理システムのローカル実行環境を構築する手順を解説します。

## 1. 事前準備 (インストール)

以下のツールがインストールされていない場合は、リンク先からダウンロード・インストールしてください。

1.  **XAMPP (PHP 8.2以上推奨)**
    *   [Apache Friends](https://www.apachefriends.org/jp/index.html)
    *   インストール時、`Apache`, `MySQL`, `PHP`, `phpMyAdmin` が選択されていることを確認してください。
2.  **Visual Studio Code (推奨エディタ)**
    *   [code.visualstudio.com](https://code.visualstudio.com/)

---

## 2. プロジェクトの配置

1.  ダウンロードした **Zipファイル** を解凍します。
2.  解凍したフォルダ一式を、XAMPPのドキュメントルート（通常は `C:\xampp\htdocs`）の中に移動します。
    *   例: `C:\xampp\htdocs\zbf-kintai-intro` となるように配置

---

## 3. なにもしなくてOK（ライブラリ確認）

配布されたファイルの中に `vendor` というフォルダがあれば、この手順は不要です。**「4. データベースのセットアップ」へ進んでください。**

※もし `vendor` フォルダがない場合のみ、以下の手順でインストールが必要です。
1.  コマンドプロンプトを開き、プロジェクトフォルダへ移動します。
    ```bash
    cd C:\xampp\htdocs\zbf-kintai-intro
    ```
2.  以下のコマンドを実行します。
    ```bash
    C:\xampp\php\php.exe composer.phar install
    ```

---

## 4. データベースのセットアップ

1.  **XAMPP Control Panel** を起動し、`Apache` と `MySQL` の [Start] を押します。
2.  ブラウザで `http://localhost/phpmyadmin` にアクセスします。
3.  **データベースの作成**:
    *   上部メニュー「データベース」をクリック。
    *   データベース名に `zbfportal` と入力。
    *   照合順序は `utf8mb4_general_ci` を選択して [作成] をクリック。

4.  **テーブルのインポート**:
    *   左サイドバーで今作成した `zbfportal` を選択。
    *   上部メニュー「インポート」をクリック。
    *   [ファイルを選択] から、プロジェクト内の `setup.sql` を選択して [インポート] を実行。
    *   **これだけで、テスト用ユーザー（`test@example.com` / `admin@example.com`）も自動的に作成されます。**

---

## 5. 設定ファイルの作成

プロジェクトには機密情報（パスワードなど）を含めないため、設定ファイル `env` が除外されています。自身の環境用に作成します。

1.  `C:\xampp\htdocs\zbf-kintai-intro` 内の `.env.example` ファイルをコピーし、`.env` という名前に変更します。
2.  `.env` ファイルをテキストエディタで開き、以下の内容を確認・修正します。

```ini
APP_ENV=local
DB_HOST=127.0.0.1
DB_PORT=3306
# ※もしMySQLのポートが3306以外(例:3309)の場合はここを変更してください
DB_DATABASE=zbfportal
DB_USERNAME=root
DB_PASSWORD=
# XAMPPの初期設定ではrootパスワードは空です
```

---

## 6. アプリケーションの起動確認

1.  ブラウザで以下のURLにアクセスします。
    *   `http://localhost/zbf-kintai-intro/`
2.  ログイン画面が表示されたら、先ほど作成したユーザーでログインします。
    *   **Email**: `test@example.com`
    *   **Password**: `password`
3.  カレンダー画面が表示されれば環境構築完了です！
    *   「一覧表示」ボタンなどを押して、動作を確認してみてください。

---

## トラブルシューティング

*   **データベース接続エラー**: `.env` の `DB_PORT` や `DB_PASSWORD` が正しいか確認してください（XAMPPのConfigボタンからmy.iniを確認）。
*   **デザインが崩れる**: ブラウザのキャッシュをクリア（Ctrl+F5）してみてください。
