<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Task;
use Illuminate\Support\Facades\DB;

class TaskController extends Controller
{    
    public function index()
    {
        return response()->json(Task::all());
    }

    public function selectTaskList()
    {
        $tasks = DB::table('tr_statuses')
        ->join('tr_projects', 'tr_statuses.pj_id', '=', 'tr_projects.pj_id')
        ->Join('tr_tasks', 'tr_tasks.status_id', '=', 'tr_statuses.status_id')
        ->leftJoin('mst_users as workers', 'tr_tasks.worker', '=', 'workers.user_id')
        ->leftJoin('mst_users as reviewers', 'tr_tasks.reviewer', '=', 'reviewers.user_id')
        ->leftJoin('mst_priorities', 'tr_tasks.priority_id', '=', 'mst_priorities.priority_id')
        ->where('tr_projects.pj_id', 1)
        ->select(
            'tr_tasks.task_id',
            'tr_tasks.task_title',
            'tr_statuses.status_id',
            'tr_statuses.status_name',
            'tr_tasks.start_date',
            'tr_tasks.end_date',
            'tr_tasks.priority_id',
            'mst_priorities.priority_name',
            'tr_tasks.worker',
            'workers.user_name as worker_name',
            'tr_tasks.reviewer',
            'reviewers.user_name as reviewer_name',
            'tr_tasks.label',
            'tr_tasks.comment'
        )
        ->orderBy('tr_tasks.task_id')
        ->orderBy('tr_statuses.status_id')
        ->get();
        return response()->json($tasks);
    }
    
    public function selectStatusTaskList()
    {
        $tasks = DB::table('tr_statuses')
            ->join('tr_projects', 'tr_statuses.pj_id', '=', 'tr_projects.pj_id')
            ->leftJoin('tr_tasks', 'tr_tasks.status_id', '=', 'tr_statuses.status_id')
            ->leftJoin('mst_users as workers', 'tr_tasks.worker', '=', 'workers.user_id')
            ->leftJoin('mst_users as reviewers', 'tr_tasks.reviewer', '=', 'reviewers.user_id')
            ->leftJoin('mst_priorities', 'tr_tasks.priority_id', '=', 'mst_priorities.priority_id')
            ->where('tr_projects.pj_id', 1)
            ->select(
                'tr_statuses.status_id',
                'tr_statuses.status_name',
                'tr_tasks.task_id',
                'tr_tasks.task_title',
                'tr_tasks.start_date',
                'tr_tasks.end_date',
                'tr_tasks.priority_id',
                'mst_priorities.priority_name',
                'tr_tasks.worker',
                'workers.user_name as worker_name',
                'tr_tasks.reviewer',
                'reviewers.user_name as reviewer_name',
                'tr_tasks.label',
                'tr_tasks.comment'
            )
            // ->orderBy('tr_tasks.priority_id','desc')
            ->orderBy('tr_statuses.status_id')
            ->orderBy('tr_tasks.priority_id','desc')
            ->orderBy('tr_tasks.task_id')
            ->get();

        $grouped = $tasks->groupBy('status_id')->map(function ($group, $statusId) {
            return [
                'status_id' => $statusId,
                'status_name' => $group->first()->status_name,
                'tasks' => $group
                    ->filter(fn($task) => $task->task_id !== null)
                    ->map(function ($task) {
                        return [
                            'task_id' => $task->task_id,
                            'task_title' => $task->task_title,
                            'start_date' => $task->start_date,
                            'end_date' => $task->end_date,
                            'priority_id' => $task->priority_id,
                            'priority_name' => $task->priority_name,
                            'worker' => $task->worker,
                            'worker_name' => $task->worker_name,
                            'reviewer' => $task->reviewer,
                            'reviewer_name' => $task->reviewer_name,
                            'label' => $task->label,
                            'comment' => $task->comment,
                        ];
                    })->values()
            ];
        })->values();

        return response()->json($grouped);
    }
}
