// vite.config.js
import { defineConfig } from 'vite'
import laravel from 'laravel-vite-plugin'
import tailwindcss from '@tailwindcss/vite'
import vue from '@vitejs/plugin-vue'

export default defineConfig({
  plugins: [
    laravel({ input: ['resources/css/App.css', 'resources/js/app.js'], refresh: true }),
    tailwindcss(),
    vue(),
  ],
  server: {
    host: '192.168.0.50',   
    port: 50002,       // Apacheと被らない番号
    strictPort: true,
    hmr: {
      host: '192.168.0.50',  // あなたの実IP（ipconfigで要確認）
      protocol: 'http',
      port: 50002
    },
    cors: true
  },
})
